<?php
/*--------------------------------------------------------------------
 Reader.php 2020-2-24
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\Readers;

use Doctrine\DBAL\Connection;
use Gambio\Shop\Attributes\ProductModifiers\Database\ValueObjects\AttributeModifierIdentifier;
use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO\AttributeWeightDto;
use Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\DTO\AttributeWeightDtoCollection;
use Gambio\Shop\ProductModifiers\Modifiers\Collections\ModifierIdentifierCollectionInterface;
use Gambio\Shop\ProductModifiers\Modifiers\ValueObjects\ModifierIdentifierInterface;

/**
 * Class Reader
 * @package Gambio\Shop\Attributes\SellingUnitWeight\Database\Repository\Readers
 */
class Reader implements ReaderInterface
{
    /**
     * @var Connection
     */
    protected $connection;
    
    
    /**
     * Reader constructor.
     *
     * @param Connection $connection
     */
    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }
    
    
    /**
     * @inheritDoc
     */
    public function attributeWeights(ModifierIdentifierCollectionInterface $modifiers): AttributeWeightDtoCollection
    {
        $result = new AttributeWeightDtoCollection;
        
        $optionValuesIds = $this->getOptionValuesIds($modifiers);
        
        if ($optionValuesIds !== '') {
            
            $queryResult = $this->connection->createQueryBuilder()
                ->select('options_values_weight, weight_prefix')
                ->from('products_attributes')
                ->where('options_values_id IN (' . $optionValuesIds . ')')
                ->execute();
            
            if ($queryResult->rowCount() !== 0) {
                
                foreach ($queryResult->fetchAll() as $row) {
                    
                    $result[] = new AttributeWeightDto((float)$row['options_values_weight'], $row['weight_prefix']);
                }
            }
        }
        
        return $result;
    }
    
    
    /**
     * @param ModifierIdentifierCollectionInterface $modifiers
     *
     * @return string
     */
    protected function getOptionValuesIds(ModifierIdentifierCollectionInterface $modifiers): string
    {
        $result = [];
        
        foreach ($modifiers as $modifier) {
            
            if ($modifier instanceof AttributeModifierIdentifier) {
                
                $result[] = (string)$modifier->value();
            }
        }
        
        return implode(', ', $result);
    }
}